<div class="relative">
    <!-- Notification Bell Button -->
    <button 
        wire:click="toggleNotificationPanel"
        class="relative inline-flex items-center px-3 py-2 text-sm font-medium text-center text-gray-600 bg-white border border-gray-300 rounded-md hover:bg-gray-50 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-gray-800 dark:text-gray-300 dark:border-gray-600 dark:hover:bg-gray-700"
    >
        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
            <path d="M10 2a6 6 0 00-6 6v3.586l-.707.707A1 1 0 004 14h12a1 1 0 00.707-1.707L16 11.586V8a6 6 0 00-6-6zM10 18a3 3 0 01-3-3h6a3 3 0 01-3 3z"></path>
        </svg>
        
        @if($unreadCount > 0)
        <span class="absolute -top-1 -right-1 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-white bg-red-600 rounded-full animate-pulse">
            {{ $unreadCount > 99 ? '99+' : $unreadCount }}
        </span>
        @endif
        
        <span class="ml-2 hidden sm:inline">Food Status</span>
    </button>

    <!-- Notification Panel -->
    @if($showNotificationPanel)
    <div class="absolute right-0 z-50 mt-2 w-80 bg-white border border-gray-200 rounded-lg shadow-lg dark:bg-gray-800 dark:border-gray-700">
        <!-- Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-200 dark:border-gray-700">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                🍽️ Food Status Updates
            </h3>
            <div class="flex items-center space-x-2">
                <!-- Sound Toggle -->
                <button 
                    wire:click="toggleSound"
                    class="p-1 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"
                    title="{{ $soundEnabled ? 'Disable Sound' : 'Enable Sound' }}"
                >
                    @if($soundEnabled)
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M9.383 3.076A1 1 0 0110 4v12a1 1 0 01-1.617.793L4.383 13H2a1 1 0 01-1-1V8a1 1 0 011-1h2.383l4-3.793a1 1 0 011.617-.793zM12 8a1 1 0 011.414 0L15 9.586l1.586-1.586A1 1 0 0118 9.414L16.414 11 18 12.586A1 1 0 0116.586 14L15 12.414 13.414 14A1 1 0 0112 12.586L13.586 11 12 9.414A1 1 0 0113.414 8z" clip-rule="evenodd"></path>
                        </svg>
                    @else
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M9.383 3.076A1 1 0 0110 4v12a1 1 0 01-1.617.793L4.383 13H2a1 1 0 01-1-1V8a1 1 0 011-1h2.383l4-3.793a1 1 0 011.617-.793zM14.657 2.929a1 1 0 011.414 0A9.972 9.972 0 0119 10a9.972 9.972 0 01-2.929 7.071 1 1 0 01-1.414-1.414A7.971 7.971 0 0017 10a7.971 7.971 0 00-2.343-5.657 1 1 0 010-1.414zm-2.829 2.828a1 1 0 011.415 0A5.983 5.983 0 0115 10a5.984 5.984 0 01-1.757 4.243 1 1 0 01-1.415-1.415A3.984 3.984 0 0013 10a3.983 3.983 0 00-1.172-2.828 1 1 0 010-1.415z" clip-rule="evenodd"></path>
                        </svg>
                    @endif
                </button>
                <!-- Close Button -->
                <button 
                    wire:click="toggleNotificationPanel"
                    class="p-1 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"
                >
                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
        </div>

        <!-- Actions -->
        @if($unreadCount > 0)
        <div class="p-2 bg-gray-50 border-b border-gray-200 dark:bg-gray-700 dark:border-gray-600">
            <div class="flex justify-between">
                <button 
                    wire:click="markAllAsRead"
                    class="text-sm text-blue-600 hover:text-blue-800 dark:text-blue-400"
                >
                    Mark all as read
                </button>
                <button 
                    wire:click="clearNotifications"
                    class="text-sm text-red-600 hover:text-red-800 dark:text-red-400"
                >
                    Clear all
                </button>
            </div>
        </div>
        @endif

        <!-- Notifications List -->
        <div class="max-h-96 overflow-y-auto">
            @forelse($notifications as $notification)
            <div class="p-3 border-b border-gray-200 dark:border-gray-700 {{ !$notification['read'] ? 'bg-blue-50 dark:bg-blue-900/20' : '' }} hover:bg-gray-50 dark:hover:bg-gray-700">
                <div class="flex items-start space-x-3">
                    <!-- Status Icon -->
                    <div class="flex-shrink-0">
                        <span class="text-2xl">{{ $this->getNotificationIcon($notification['status']) }}</span>
                    </div>
                    
                    <!-- Content -->
                    <div class="flex-1 min-w-0">
                        <div class="flex items-center justify-between">
                            <p class="text-sm font-medium text-gray-900 dark:text-white">
                                Table {{ $notification['table_code'] }}
                            </p>
                            <span class="inline-flex px-2 py-1 text-xs font-medium rounded-full {{ $this->getNotificationColor($notification['priority']) }}">
                                {{ ucfirst(str_replace('_', ' ', $notification['status'])) }}
                            </span>
                        </div>
                        
                        <p class="text-sm text-gray-600 dark:text-gray-300">
                            Order #{{ $notification['order_number'] }}
                        </p>
                        
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            Waiter: {{ $notification['waiter_name'] }}
                        </p>
                        
                        <p class="text-xs text-gray-400 dark:text-gray-500 mt-1">
                            {{ \Carbon\Carbon::parse($notification['timestamp'])->diffForHumans() }}
                        </p>
                        
                        <!-- Action Buttons for Food Ready Status -->
                        @if($notification['status'] === 'food_ready' && !$notification['read'])
                        <div class="flex space-x-2 mt-2">
                            <button 
                                wire:click="markOrderServed({'kotId': {{ $notification['kot_id'] }}, 'notificationId': '{{ $notification['id'] }}'})"
                                class="px-3 py-1 text-xs font-medium text-white bg-green-600 rounded hover:bg-green-700"
                            >
                                Mark Served
                            </button>
                            <button 
                                wire:click="viewKotDetails({'kotId': {{ $notification['kot_id'] }}, 'notificationId': '{{ $notification['id'] }}'})"
                                class="px-3 py-1 text-xs font-medium text-gray-600 bg-gray-100 rounded hover:bg-gray-200 dark:bg-gray-600 dark:text-gray-300"
                            >
                                View KOT
                            </button>
                        </div>
                        @endif
                    </div>
                    
                    <!-- Unread Indicator -->
                    @if(!$notification['read'])
                    <div class="flex-shrink-0">
                        <span class="w-2 h-2 bg-blue-600 rounded-full inline-block"></span>
                    </div>
                    @endif
                </div>
            </div>
            @empty
            <div class="p-4 text-center text-gray-500 dark:text-gray-400">
                <svg class="w-12 h-12 mx-auto mb-2 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5-5V9c0-1.1-.9-2-2-2H6c-1.1 0-2 .9-2 2v3l-5 5h5v3c0 .55.45 1 1 1h4c.55 0 1-.45 1-1v-3z"></path>
                </svg>
                <p class="text-sm">No notifications yet</p>
                <p class="text-xs text-gray-400">Food status updates will appear here</p>
            </div>
            @endforelse
        </div>
    </div>
    @endif

    <!-- Sound Files -->
    @script
    <script>
        let notificationSound = null;
        
        // Preload sound
        function preloadSound() {
            notificationSound = new Audio("{{ asset('sound/new_order.wav') }}");
            notificationSound.preload = 'auto';
        }
        
        // Play notification sound
        function playSound() {
            if (notificationSound) {
                notificationSound.currentTime = 0;
                notificationSound.play().catch(e => console.log('Could not play sound:', e));
            }
        }
        
        // Initialize sound on page load
        document.addEventListener('DOMContentLoaded', preloadSound);
        
        // Listen for sound play event
        $wire.on('playNotificationSound', () => {
            playSound();
        });
    </script>
    @endscript
</div>