# 🍽️ Food Status Notifications System

## Overview
This enhanced notification system provides real-time alerts to waiters when food status changes in the kitchen, significantly reducing the need for manual checking and improving restaurant workflow efficiency.

## Features

### ✨ Real-Time Notifications
- **Instant Alerts**: Waiters receive immediate notifications when food is ready
- **Sound Alerts**: Audio notifications for high-priority status changes
- **Visual Popups**: SweetAlert2 modals with action buttons
- **Push Notifications**: Browser push notifications via Pusher Beams

### 🔔 Notification Types
1. **Food Ready** (High Priority)
   - Immediate popup with "Mark as Served" button
   - Sound alert
   - Browser push notification
   - Visual indicator in notification panel

2. **Food Served** (Medium Priority)
   - Informational notification
   - No sound alert
   - Visual confirmation

3. **In Kitchen** (Low Priority)
   - Status update only
   - Minimal visual indication

### 🎯 Smart Targeting
- **Assigned Waiter**: Primary recipient for table-specific orders
- **All Waiters**: Fallback when assigned waiter is unavailable
- **Managers**: Always included for oversight
- **Restaurant Admin**: Always included

## How It Works

### 1. Kitchen Staff Workflow
1. Kitchen staff receives order via KOT (Kitchen Order Ticket)
2. When food is prepared, they click "Food is Ready" button
3. System automatically triggers notifications to relevant waiters

### 2. Waiter Workflow
1. Waiter receives real-time notification with sound alert
2. Popup appears with order details and action buttons:
   - **Mark as Served**: Updates status and removes from queue
   - **View KOT**: Navigate to detailed order view
3. Notification appears in bell icon with unread count
4. Waiter can view notification history in dropdown panel

### 3. Notification Panel Features
- **Unread Counter**: Shows number of pending notifications
- **Sound Toggle**: Enable/disable audio alerts
- **Mark All Read**: Clear all unread notifications
- **Clear All**: Remove all notifications
- **Quick Actions**: Direct buttons for common actions

## Setup and Configuration

### 1. Pusher Beams Setup
1. Go to Settings → Push Notification Settings
2. Enable push notifications
3. Enter your Pusher Instance ID and Beam Secret
4. Configure in `.env`:
   ```
   BROADCAST_DRIVER=pusher
   PUSHER_APP_ID=your_app_id
   PUSHER_APP_KEY=your_key
   PUSHER_APP_SECRET=your_secret
   PUSHER_APP_CLUSTER=your_cluster
   ```

### 2. Queue Configuration
For optimal performance, configure queues:
```bash
php artisan queue:work
```

### 3. Broadcasting Channels
The system uses private channels for security:
- `restaurant.{restaurant_id}`: Restaurant-wide notifications
- `branch.{branch_id}`: Branch-specific notifications  
- `waiter.{user_id}`: User-specific notifications

## Testing

### Manual Testing
1. Create an order with KOT
2. Change KOT status from "In Kitchen" to "Food Ready"
3. Check that notifications appear for waiters
4. Verify sound plays and popup shows

### Command Line Testing
```bash
php artisan test:food-status-notification {kotId} {status}
```

Example:
```bash
php artisan test:food-status-notification 1 food_ready
```

## Notification UI Components

### 1. Navigation Bell Icon
- Located in top navigation bar
- Shows unread notification count
- Click to toggle notification panel

### 2. Notification Panel
- Dropdown panel with recent notifications
- Color-coded by priority (red=high, blue=medium, gray=low)
- Time stamps with "time ago" format
- Quick action buttons for food_ready status

### 3. Popup Modals
- Full-screen modal for high-priority notifications
- Contextual action buttons
- Auto-dismissal options
- Sound integration

## Customization

### Sound Files
- Default: `/public/sound/new_order.wav`
- Can be customized by replacing the file
- Supports WAV, MP3, OGG formats

### Notification Messages
Edit in `app/Events/FoodStatusChanged.php`:
```php
private function getStatusMessage(): string
{
    // Customize messages here
}
```

### Visual Styling
Modify `resources/views/livewire/dashboard/food-status-notifications.blade.php`

## Troubleshooting

### Common Issues

1. **No Notifications Appearing**
   - Check Pusher configuration
   - Verify user permissions
   - Check browser notification permissions

2. **No Sound Playing**
   - Check browser autoplay policies
   - Verify sound files exist
   - Check user sound preference

3. **Push Notifications Not Working**
   - Verify Pusher Beams configuration
   - Check SSL certificate (required for push notifications)
   - Verify user is authenticated

### Debug Commands
```bash
# Check event listeners
php artisan event:list

# Monitor queue jobs
php artisan queue:monitor

# Check logs
tail -f storage/logs/laravel.log
```

## Performance Considerations

- **Polling**: KOT page polls every 10 seconds for updates
- **Memory**: Notifications limited to 50 per user to prevent memory issues
- **Queue**: Event listeners run in background via queue system
- **Caching**: User sessions cache notification preferences

## Security

- **Private Channels**: All broadcasts use authenticated private channels
- **User Verification**: Only restaurant staff receive notifications
- **CSRF Protection**: All forms include CSRF tokens
- **Permission Checks**: User permissions verified before notification dispatch

## Future Enhancements

- **Mobile App Integration**: Push notifications to mobile apps
- **SMS Notifications**: Fallback for critical alerts
- **Delivery Integration**: Notifications for delivery status
- **Analytics**: Notification response time tracking
- **Custom Sounds**: Per-user notification sound preferences